VERSION 5.00
Object = "{19B7F2A2-1610-11D3-BF30-1AF820524153}#1.1#0"; "ccrpftv6.ocx"
Begin VB.Form Form1 
   Caption         =   "CCRP FolderTreeview Control/Explorer stress demo (VB6)"
   ClientHeight    =   6180
   ClientLeft      =   1905
   ClientTop       =   2340
   ClientWidth     =   8490
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   6180
   ScaleWidth      =   8490
   Begin CCRPFolderTV6.FolderTreeview FTV1 
      Height          =   2460
      Left            =   1380
      TabIndex        =   13
      Top             =   2700
      Width           =   3615
      _ExtentX        =   6376
      _ExtentY        =   4339
      IntegralHeight  =   0   'False
   End
   Begin VB.Frame Frame1 
      Caption         =   "FTV"
      ClipControls    =   0   'False
      Height          =   675
      Left            =   4140
      TabIndex        =   6
      ToolTipText     =   "FolderTreeview members that walk the whole tree"
      Top             =   30
      Width           =   4215
      Begin VB.CheckBox chkVirtualFolders 
         Caption         =   "&VirtualFolders"
         Height          =   255
         Left            =   2760
         TabIndex        =   11
         Top             =   390
         Width           =   1410
      End
      Begin VB.CheckBox chkOverlayIcons 
         Caption         =   "&OverlayIcons"
         Height          =   255
         Left            =   2760
         TabIndex        =   10
         Top             =   150
         Width           =   1410
      End
      Begin VB.CheckBox chkHiddenFolders 
         Caption         =   "&HiddenFolders"
         Height          =   255
         Left            =   1260
         TabIndex        =   9
         Top             =   390
         Width           =   1500
      End
      Begin VB.CheckBox chkAutoUpdate 
         Caption         =   "&AutoUpdate"
         Height          =   255
         Left            =   1260
         TabIndex        =   8
         Top             =   150
         Width           =   1500
      End
      Begin VB.CommandButton cmdRefresh 
         Caption         =   "&Refresh"
         Height          =   345
         Left            =   180
         TabIndex        =   7
         Top             =   240
         Width           =   915
      End
   End
   Begin VB.OptionButton Option1 
      Caption         =   "&Explorer"
      Height          =   285
      Index           =   1
      Left            =   3120
      TabIndex        =   5
      Top             =   420
      Width           =   1020
   End
   Begin VB.OptionButton Option1 
      Caption         =   "&FTV"
      Height          =   285
      Index           =   0
      Left            =   3120
      TabIndex        =   4
      Top             =   90
      Width           =   1020
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "&Stop"
      Height          =   345
      Left            =   2100
      TabIndex        =   2
      Top             =   90
      Width           =   915
   End
   Begin VB.CommandButton cmdPause 
      Caption         =   "&Pause"
      Height          =   345
      Left            =   1080
      TabIndex        =   1
      Top             =   90
      Width           =   915
   End
   Begin VB.CommandButton cmdGo 
      Caption         =   "&Go"
      Height          =   345
      Left            =   60
      TabIndex        =   0
      Top             =   90
      Width           =   915
   End
   Begin VB.Label Label2 
      Caption         =   "FolderTreeview designtime property settings : Name = ""FTV1"", IntegralHeight = False"
      Height          =   615
      Left            =   1410
      TabIndex        =   12
      Top             =   1800
      Visible         =   0   'False
      Width           =   3375
   End
   Begin VB.Label Label1 
      Caption         =   "Label1"
      Height          =   225
      Left            =   60
      TabIndex        =   3
      Top             =   480
      Width           =   2895
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates how to expand all local fixed drive folders in both the
' FolderTreeview control and in an Explorer window. Was used for stress
' testing and speed comparison purposes during FTV development.
'
' Note that because this demo controls an out-of-process Explorer treeview,
' do not attempt to interact with the Explorer window while this application is
' expanding it treeview's folders, or unpredictable results may occur... (worse
' case scenario is an Explorer application error, though in rare instances
' Window could conceivably crash). Be warned.
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

Private m_fRunning As Boolean
Private m_fPause As Boolean
Private m_yFTV As Long               ' FolderTreeview's y coord
Private m_hwndExplTV As Long   ' handle of Explorer window's treeview
'

Private Sub Form_Load()
  
  m_yFTV = Frame1.Top + Frame1.Height + 60
  If (m_yFTV < 720) Or (m_yFTV > 810) Then m_yFTV = 765
  
  KeyPreview = True
  cmdPause.Enabled = False
  cmdStop.Enabled = False
  Option1(0) = True
  
  With FTV1
    chkAutoUpdate = Abs(.AutoUpdate)
    chkHiddenFolders = Abs(.HiddenFolders)
    chkOverlayIcons = Abs(.OverlayIcons)
    chkVirtualFolders = Abs(.VirtualFolders)
  End With
  
End Sub

Private Sub Form_Resize()
  If (ScaleHeight > m_yFTV) Then
    If (WindowState <> vbMinimized) Then
      FTV1.Move 0, m_yFTV, ScaleWidth, ScaleHeight - m_yFTV
    End If
  End If
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case vbKeyEscape: m_fRunning = False
    Case vbKeyPause: Call cmdPause_Click
    Case vbKeyF5: Call cmdRefresh_Click
  End Select
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  
  ' Don't allow the app to close while we're in the middle of expanding
  ' either the FTV's or Explorer's treeview's, or bad things may happen...
  If m_fRunning Then
    Label1 = "Can't close while running, click Stop first"
    If (m_fPause = False) Then DoEvents: Sleep 1500
    Cancel = 1
  End If

End Sub

Private Sub cmdGo_Click()
  Dim hitemMyComputer As Long
  
  If m_fRunning Then Exit Sub
  
  m_fRunning = True
  m_fPause = False

  cmdGo.Enabled = False
  cmdPause.Enabled = True
  cmdStop.Enabled = True
  
  ' Get the specified treeview's My Comptuer folder, and expand
  ' all of its local drive folders...
  If Option1(0) Then
    
    ' If either FTV prop below is changed and a folder is removed
    ' while it is being expanded, the folder's hItem will be invalid,
    ' and Comctl32.dll will blow up when trying to use the hItem.
    chkHiddenFolders.Enabled = False
    chkVirtualFolders.Enabled = False
  
    ' Go with explicit FTV1 references so we're not in a
    ' With block during all of the recursive ExpandTVItemSiblings calls.
    FTV1.SelectedFolder = FTV1.GetSpecialFolderName(ftvMyComputer)
    If (FTV1.SelectedFolder = FTV1.GetSpecialFolderName(ftvMyComputer)) Then
      Call ExpandFixedDriveFolders(FTV1.hWnd, FTV1.SelectedFolder.hItemTV)
    End If
    
    chkHiddenFolders.Enabled = True
    chkVirtualFolders.Enabled = True
  
  Else   ' explorer
    
    ' Get an Explorer treeview's window handle and a handle to
    ' its My Computer treeview item.
    If (IsWindow(m_hwndExplTV) = 0) Then
      m_hwndExplTV = GetExplorerTreeview(hitemMyComputer)
    Else
      hitemMyComputer = TreeView_GetRoot(m_hwndExplTV)
    End If
    
    If IsWindow(m_hwndExplTV) And (hitemMyComputer <> 0) Then
      Call ExpandFixedDriveFolders(m_hwndExplTV, hitemMyComputer)
    End If
  
  End If   ' Option1(0)
  
  cmdGo.Enabled = True
  cmdPause.Enabled = False
  cmdPause.Caption = "&Pause"
  cmdStop.Enabled = False
  Call ShowTVFolderCount
  
  m_fRunning = False

End Sub

Private Sub ExpandFixedDriveFolders(hwndTV As Long, hitemMyComputer As Long)
  Dim hitemDrive As Long
  Dim dwDriveBits As Long
  Dim wHighBit As Integer
  Dim wBit As Integer
  
  If hitemMyComputer Then
    ' Expand the My Computer folder
    Call TreeView_Expand(hwndTV, hitemMyComputer, TVE_EXPAND)
  
    ' Get the My Computer folder's first child drive folder (A, B, or C)
    hitemDrive = TreeView_GetChild(hwndTV, hitemMyComputer)
    If hitemDrive Then
      
      ' If GetLogicalDrives() succeeds, it returns a bitmask representing
      ' the currently available drives. Bit 0 (the least-significant bit) is drive
      ' A, bit 1 is drive B, bit 2 is drive C, and so on.
      dwDriveBits = GetLogicalDrives()
      If (dwDriveBits = 0) Then Exit Sub
      
      ' Get the zero based position of the highest bit set in the bitmask
      ' (essentially determining the value's highest complete power of 2).
      ' Use floating point division (we want the exact values from the Logs)
      ' and remove the fractional value (the fraction indicates the value of
      ' the last incomplete power of 2, which means the bit isn't set).
      wHighBit = Int(Log(dwDriveBits) / Log(2))
      
      ' For each bit to the high bit
      For wBit = 0 To wHighBit
        
        ' If not running or for some reason we don''t have a drive hItem anymore, bail...
        If (m_fRunning = False) Or (hitemDrive = 0) Then Exit Sub
        
        ' If the bit in the bitmask is set...
        If ((2 ^ wBit) And dwDriveBits) Then
          
          ' The bit is set, if the drive is fixed...
          If (GetDriveType(Chr$(vbKeyA + wBit) & ":\") = DRIVE_FIXED) Then
            
            ' Expand the drive folder and all of its subfolders, starting with its first child.
            Call TreeView_Expand(hwndTV, hitemDrive, TVE_EXPAND)
            Call ExpandTVItemSiblings(hwndTV, TreeView_GetChild(hwndTV, hitemDrive))
          
          End If   ' GetDriveType
          
          ' Get the hitem of the next sibling drive folder.
          hitemDrive = TreeView_GetNextSibling(hwndTV, hitemDrive)
          
        End If   ' ((2 ^ wBit) And dwDriveBits)
      Next
    
    End If   ' hitemDrive
  End If   ' hitemMyComputer
  
End Sub
'
'Private Sub ExpandFTVSelectedFolder()
'  m_fRunning = True
'  Call ExpandTVItemSiblings(FTV1.hWnd, FTV1.SelectedFolder.hItemTV)
'  m_fRunning = False
'End Sub

Private Sub ExpandTVItemSiblings(hwndTV As Long, hitemSib As Long)
  
  Call ShowTVFolderCount
  DoEvents
  
  Do While hitemSib
    Do While m_fPause And m_fRunning: DoEvents: Loop
    If (m_fRunning = False) Then Exit Sub
    
    Call TreeView_Expand(hwndTV, hitemSib, TVE_EXPAND)
    Call ExpandTVItemSiblings(hwndTV, TreeView_GetChild(hwndTV, hitemSib))
    
    ' Check the flag again after returning from the recusive call. If hitemSib
    ' no longer exists and we try to use it below, Comctl32.dll will GPF.
    If (m_fRunning = False) Then Exit Sub
    
    hitemSib = TreeView_GetNextSibling(hwndTV, hitemSib)
  Loop

End Sub

Private Sub cmdPause_Click()
  
  If m_fRunning Then
    m_fPause = Not m_fPause
    If m_fPause Then
      cmdPause.Caption = "Un&pause"
    Else
      cmdPause.Caption = "&Pause"
    End If
  End If

End Sub

Private Sub cmdStop_Click()
  m_fRunning = False
End Sub

Private Sub Option1_Click(Index As Integer)
  
  Frame1.Enabled = (Index = 0)
  cmdRefresh.Enabled = (Index = 0)
  chkAutoUpdate.Enabled = (Index = 0)
  chkOverlayIcons.Enabled = (Index = 0)
  
  If (m_fRunning = False) Then
    chkHiddenFolders.Enabled = (Index = 0)
    chkVirtualFolders.Enabled = (Index = 0)
  End If
  
  Call ShowTVFolderCount

End Sub

Private Sub ShowTVFolderCount()
  
  If Option1(0) Then
    Label1 = "FTV folder count: " & TreeView_GetCount(FTV1.hWnd)
  ElseIf IsWindow(m_hwndExplTV) Then
    Label1 = "Explorer TV folder count: " & TreeView_GetCount(m_hwndExplTV)
  Else
    Label1 = "Explorer TV is unavailable (click Go)"
  End If

End Sub

Private Sub cmdRefresh_Click()
  FTV1.Refresh
  Call ShowTVFolderCount
End Sub

Private Sub chkAutoUpdate_Click()
  FTV1.AutoUpdate = CBool(chkAutoUpdate)
End Sub

Private Sub chkHiddenFolders_Click()
  FTV1.HiddenFolders = CBool(chkHiddenFolders)
  Call ShowTVFolderCount
End Sub

Private Sub chkOverlayIcons_Click()
  FTV1.OverlayIcons = CBool(chkOverlayIcons)
  Call ShowTVFolderCount
End Sub

Private Sub chkVirtualFolders_Click()
  FTV1.VirtualFolders = CBool(chkVirtualFolders)
  Call ShowTVFolderCount
End Sub

Private Sub FTV1_Expand(Folder As CCRPFolderTV6.Folder, PreExpand As Boolean, Cancel As Boolean)
  If (PreExpand = False) Then Call ShowTVFolderCount
End Sub

' Shells an Explorer window with the My Computer folder as its root,
' finds and returns the window handle of its treeview, fills the hItem
' param with the handle of the treeview's My Computer folder.

Private Function GetExplorerTreeview(hItem As Long) As Long
  Dim dwStart As Long
  Dim hwndExpl As Long
  Dim hwndTV As Long
  
  ' Open an Explorer window with the My Computer folder as its root folder
  Call Shell("explorer.exe /e,/root,::" & CLSID_MyComputer, vbNormalFocus)
  
  ' Find the Explorer window in the foreground, the art of kludge...
  dwStart = GetTickCount
  Do
    hwndExpl = GetForegroundWindow
  Loop Until IsWindowClassname(hwndExpl, WC_EXPLORER) Or ((GetTickCount - dwStart) > 5000)
  
  If hwndExpl Then
    ' more art, don't do anything until Explorer is visible
    dwStart = GetTickCount
    Do Until IsWindowVisible(hwndExpl) Or ((GetTickCount - dwStart) > 5000)
    Loop
    
    ' give Explorer a little more time to do whatever else it needs to do... <yawn>
    Sleep 2000
    
    ' Get Explorer's treeview
    hwndTV = GetChildWindowFromClassname(hwndExpl, WC_TREEVIEW)
    If hwndTV Then
      
      ' Fill the hItem param with the My Computer root folder's hItem
      ' and return the Explorer window handle on success.
      hItem = TreeView_GetRoot(hwndTV)
      If hItem Then GetExplorerTreeview = hwndTV
      
    End If   ' hwndTV
  End If   ' hwndExpl
  
End Function
